/*
 * config.c
 *
 *  Created on: Mar 31, 2015
 *      Author: Jordan
 */

#include "gio.h"
#include "etpwm.h"
#include "ecap.h"
#include "spi.h"
#include "sci.h"
#include "rti.h"
#include "stdio.h"
#include "ms5611.h"
#include "mpu6000.h"
#include "navigation.h"
#include "control.h"
#include "telemetry.h"
#include "hmc5883.h"
#include "i2c.h"
#include "gps.h"
#include "config.h"

void system_init(){
	gioInit();
	etpwmInit();
	ecapInit();
	spiInit();
	sciInit();
	rtiInit();

	rtiStartCounter(rtiCOUNTER_BLOCK0);

	_enable_IRQ();

	gioSetBit(gioPORTA,0,1);
	delay_ms(350);
	i2cInit();

	ms5611_init();
	mpu6000_init();
	hmc5883_init();
	gps_init();

	AHRS_init();
	telemetry_init();

	read_PID_params();

	rtiEnableNotification(rtiNOTIFICATION_COMPARE1);
}

sint16 sci_printf(const char *_format, ...){
   char str[128];
   sint16 length = -1;

   va_list argList;
   va_start( argList, _format );

   length = vsnprintf(str, sizeof(str), _format, argList);

   va_end( argList );

   if (length > 0)
   {
      sciSend(sciREG, (unsigned)length, (unsigned char*)str);
   }

   return length;
}

uint32 delay_count;
void delay_ms(float32 ms){
	delay_count = (uint32) (ms*1000);
	rtiEnableNotification(rtiNOTIFICATION_COMPARE0);
	while(delay_count);
	rtiDisableNotification(rtiNOTIFICATION_COMPARE0);
}

uint32 timer_count;
void timer_start(){
	timer_count = 0;
	rtiEnableNotification(rtiNOTIFICATION_COMPARE2);
}

float32 timer_stop(){
	rtiDisableNotification(rtiNOTIFICATION_COMPARE2);
	return (float32) timer_count/20;
}

uint8 autopilot_tick;
void rtiNotification(uint32 notification)
{
	switch(notification){
		case rtiNOTIFICATION_COMPARE0:
			delay_count = delay_count > 0 ? --delay_count : 0;
			break;
		case rtiNOTIFICATION_COMPARE1:
			autopilot_tick = 1;
			break;
		case rtiNOTIFICATION_COMPARE2:
			timer_count++;
			break;
	}
}
